<div class='row'>

    <div class='col-lg-5 mb-4'>
        
        <div class='card mb-4'>
            <h5 class='card-header'>Sender</h5>
            <div class='card-body'>
                <div class='p-3'>

                    <?php if( empty($transfer->meta['sender']) ): ?>

                        <h3 class='fw-normal text-center'>
                            <i class='bi bi-emoji-frown'></i> <br/>
                            No Sender Information Found
                        </h3>

                    <?php else: ?>

                        <?php $transfer->printTxField( $transfer->meta['sender'] ); ?>

                    <?php endif; ?>

                </div>
            </div>
        </div>

        <div class='card'>
            <h5 class='card-header'>Receiver</h5>
            <div class='card-body'>
                <div class='p-3'>
                    
                    <?php if( empty($transfer->meta['receiver']) ): ?>

                        <h3 class='fw-normal text-center'>
                            <i class='bi bi-emoji-dizzy'></i> <br/>
                            No Receiver Information Found
                        </h3>

                    <?php else: ?>

                        <?php $transfer->printTxField( $transfer->meta['receiver'] ); ?>

                    <?php endif; ?>

                </div>
            </div>
        </div>

    </div>

    <div class='col-lg-7'>

        <div class='card'>
            <h4 class='card-header'>Transaction Detail</h4>
            <div class='card-body'>

                <div class='p-3'>

                    <form method='POST'>

                        <?php

                            $data = array();

                            foreach( $transfer->transfer as $key => $value ) {

                                if( in_array($key, ['id', 'tx_status']) ) continue;
                                
                                $icon = $transfer->getComponent($key, 'icon') ?? "<i class='bi bi-question-circle'></i>";
                                $attr = Core::array_to_html_attrs( $transfer->getComponent($key, 'attr') ?? [] );
                                $type = $transfer->getComponent($key, 'type') ?? 'text';

                                $options = $transfer->getComponent($key, 'options');
                                
                                if( !empty($options) ) {
                                    $input = "<select name='{$key}' class='form-select text-capitalize' value='{$value}' {$attr}>";
                                    foreach( $options as $index => $output ) {
                                        $input .= "<option value='{$index}'>{$output}</option>";
                                    };
                                    $input .= "</select>";
                                } else if( $type == 'textarea' ) {
                                    $input = "<textarea name='{$key}' class='form-control' {$attr}>{$value}</textarea>";
                                } else {
                                    $input = "<input name='{$key}' type='{$type}' class='form-control' value='{$value}' {$attr}>";
                                };

                                $data[] = [
                                    "key" => ucwords(str_replace(
                                        ["tx_", "_"], 
                                        [null, " "],
                                        $key
                                    )),
                                    "value" => "
                                        <div class='input-group'>
                                            <span class='input-group-text'>{$icon}</span>
                                            {$input}
                                        </div>
                                    "
                                ];

                            };
                            
                            $tablet = new DOMTablet( 'tx-info' );

                            $tablet->data( $data );

                            $tablet->columns([
                                'key',
                                'value'
                            ]);

                            $th = $tablet->table->getElementsByTagName('thead')->item(0);
                            $th->setAttribute('class', 'd-none');

                            $tablet->chunk(20);

                            $tablet->prepare(function($data) {


                                return $data;
                            }, true);

                        ?>

                        <div class=''>
                            <button class='btn btn-primary w-100'>
                                <i class='bi bi-capslock'></i> Update
                            </button>
                        </div>
                    
                    </form>

                </div>
                
            </div>
        </div>

    </div>

</div>