<?php

$exchangeRoute = $managementRoute . "/exchanges";

$exchangeMenu = $managementMenu->add("exchange", [
    "label" => "exchanges",
    "href" => Core::url( ROOT_DIR . "/{$exchangeRoute}" )
]);

# Focus;

Uss::route( $exchangeRoute . "(?:/(\d+))?", function() use($exchangeMenu) {

    $exchangeMenu->setAttr('active', true);
    $exchangeMenu->parentMenu->setAttr('active', true);

    require_once MANG_DIR . "/request/exchanges.php";
    
    Udash::view(function() use($exchange) {     

        $SQL = SQuery::select( $exchange->table, "1 ORDER BY id DESC" );

        $result = Uss::$global['mysqli']->query( $SQL );

        $tablet = new DOMTablet( 'exchange' );

        $tablet->data ( $result );

        $tablet->columns([
            'user',
            'paid',
            'expects',
            'status',
            'action' => ''
        ]);

        $tablet->wrap();

        $tablet->prepare(function($data) {

            # Get user

            $user = Udash::fetch_assoc( DB_TABLE_PREFIX . "_users", $data['userid'] );
            $href = $user ? Bank::userURL( $user['usercode'] ) : "javascript:void(0)";
            $email = $user ? $user['email'] : '<i class="bi bi-question-circle"></i>';

            $data['user'] = "<a href='{$href}'>{$email}</a>";

            $data['paid'] = number_format($data['paid_amount'],2 ) . " {$data['paid_currency']}";

            $data['expects'] = number_format($data['expected_amount'],2 ) . " {$data['expected_currency']}";
            
            $color = Udash::get_color( $data['status'] );
            $data['status'] = "<span class='badge bg-{$color}'>{$data['status']}</span>";

            $data['action'] = "
                <form method='POST' data-uss-confirm='Please confirm the process to continue'>
                    <input type='hidden' name='id' value='{$data['id']}'>
                    <button class='btn btn-outline-success' name='status' value='approved'>
                        <i class='bi bi-check-circle'></i>
                    </button>
                    <button class='btn btn-outline-warning' name='status' value='declined'>
                        <i class='bi bi-exclamation-circle'></i>
                    </button>
                </form>
            ";

            return $data;

        }, true);

    });

}, null);

