<div class='container-fluid'>
    <div class='row'>
        <div class='col-lg-7 py-5 mx-auto'>

            <div class='border rounded-1 p-5 shadow-sm mb-4'>

                <div class='mb-3'>
                    <figure>
                        <img src='<?php echo Uss::$global['icon']; ?>' height='60px'>
                    </figure>
                </div>

                <div class='row row-cols-2 mb-3'>
                    <div class='col'>
                        <div>Document Requested By:</div>
                        <div>%{user.firstname} %{user.lastname}</div>
                        <div class='my-3'></div>
                    </div>
                    <div class='col'>
                        <p>Account Number:</p>
                        <div class='text-primary'>%{user.bank_number}</div>
                    </div>
                </div>

                <div class='row row-cols-2'>
                    <div class='col'>
                        <?php echo Uss::$global['title']; ?>
                    </div>
                    <div class='col'>
                        <?php echo $datetime->format('1S, M Y'); ?> 
                        <span class=''>&mdash;</span>
                        <?php echo $datetime->format('tS, M Y'); ?>
                    </div>
                </div>

                <hr/>

                <div class='d-flex justify-content-between mb-2'>
                    <div class=''>Money In</div>
                    <div class='text-success'><?php echo $money['in']['value']; ?></div>
                </div>
                
                <div class='d-flex justify-content-between mb-2'>
                    <div class=''>Money Out</div>
                    <div class='text-danger'><?php echo $money['out']['value']; ?></div>
                </div>
                
                <div class='d-flex justify-content-between mb-2'>
                    <div class=''>Recurring</div>
                    <div class='text-info'>
                        <?php echo $money['recurring']; ?>
                    </div>
                </div>

                <hr/>

                <h4 class='fw-light mb-3'>Your Transactions:</h4>

                <?php

                    $tablet = new DOMTablet( 'space' );

                    $tablet->data($result);
                    $tablet->columns([
                        'date' => 'date',
                        'money_in' => 'money in',
                        'money_out' => 'money out',
                        'balance'
                    ]);

                    $tablet->prepare(function($data) {

                        $data['date'] = (new DateTime($data['tx_date']))->format('Y-M-dS');
                        $converter = new Converter(Uss::$global['user']['id'], 'to');

                        $income = $converter->from('USD')->amount($data['money_in'])->convert();
                        $output = $converter->from('USD')->amount($data['money_out'])->convert();

                        $data['money_in'] = $income->symbol . number_format($income->amount, 2);
                        $data['money_out'] = $output->symbol . number_format($output->amount, 2);
                        
                        $balance = (float)$income->amount - (float)$output->amount;

                        $data['balance'] = $income->symbol . number_format($balance, 2);
                        
                        return $data;

                    }, true);

                ?>

                <hr/>

                <p class='fs-14px'>
                    If you think something is incorrect, please contact us at <?php echo Uss::$global['options']->get('site:phone'); ?> <br/>
                    <?php echo Uss::$global['title']; ?>. <br/> 
                    Registered Office: <?php echo Uss::$global['options']->get('site:address'); ?> <br/>
                    Website: <?php echo $_SERVER['SERVER_NAME']; ?>
                </p>

            </div>

            <button class='btn btn-primary w-100 btn-lg' onclick='window.print()'>
                Print Statement
            </button>

        </div>
    </div>
</div>