<?php 

defined( 'UADMIN_DIR' ) OR DIE;

Uss::route( $FOCUS, function() {
	
	require __DIR__ . '/POST/ticket.php';
	
	events::addListener('uadmin/pages/support-ticket::QUERY', function($data) {
		
		$prefix = DB_TABLE_PREFIX;
		
		if( empty($_GET['search']) ) $TERMS = NULL;
		
		else {
			
			$search = Uss::$global['mysqli']->real_escape_string( $_GET['search'] );
			
			$TERMS = "
				WHERE CONCAT_WS( ' ',
					{$prefix}_tickets.uniqid,
					{$prefix}_tickets.status,
					{$prefix}_tickets.subject,
					{$prefix}_tickets.description,
					{$prefix}_users.username,
					{$prefix}_users.email
				) LIKE '%{$search}%'
					
			";
			
		};
		
		$data['SQL'] = "
			
			SELECT
				
				TICKETS.*,
				IFNULL(REPLIES.unseen, 0) AS unseen
				
			FROM (
			
				SELECT 
				
					{$prefix}_tickets.*,
					COUNT({$prefix}_ticket_replies.ticket_id) AS chats
					
				FROM {$prefix}_tickets
				
				INNER JOIN {$prefix}_users
					ON {$prefix}_users.id = {$prefix}_tickets.userid
				
				LEFT JOIN {$prefix}_ticket_replies
					ON {$prefix}_tickets.id = {$prefix}_ticket_replies.ticket_id
					
				{$TERMS}
					
				GROUP BY {$prefix}_tickets.id
				
				ORDER BY 
					{$prefix}_tickets.status = 'open' DESC, 
					{$prefix}_tickets.id DESC
				
			) AS TICKETS
			
			LEFT JOIN (
			
				SELECT
					
					{$prefix}_ticket_replies.ticket_id,
					COUNT({$prefix}_ticket_replies.seen) AS unseen
					
				FROM {$prefix}_ticket_replies
				
				WHERE viewpoint = 'client'
					AND seen = 0
					
				GROUP BY {$prefix}_ticket_replies.ticket_id
			
			) AS REPLIES
			
				ON TICKETS.id = REPLIES.ticket_id
			
		";
		
		$tickets = Uss::$global['mysqli']->query( $data['SQL'] );
		
		$table = &$data['table'];
		
		$table->data( $tickets );
		$table->wrap();
		$table->columns(array('content' => ''));
		
		$table->setWidget('search', true);
		$table->setWidget('bulk', array(
			'delete' => 'delete'
		), 'id');
	
	});
	
	
	//! Declear the admin query component!
	
	$SQL = '';
	$table = new DOMTablet( 'tickets' );
	
	events::exec("uadmin/pages/support-ticket::QUERY", array(
		'SQL' => &$SQL,
		'table' => &$table
	));
	
	
	//! Display the admin cPanel
	
	udash::view(function() use($table) {
		
		$table->table->setAttribute('class', $table->table->getAttribute('class') . ' plain thead-none');
		
	?>
	
	<div class='container-fluid'>
		
		<?php 
		
			$table->prepare(function($data) use($table) {
				
				$avatar = udash::user_avatar($data['userid']);
				$summary = substr(strip_tags( $data['description'] ), 0, 70) . "&hellip;";
				
				$href = Uss::$global['menu']->get('ticket')->getAttr('href') . "/{$data['uniqid']}";
				
				$color = udash::get_color($data['status']);
				
				if( empty($data['unseen']) ) $alert = null;
				else {
					$alert = "
						<span class='badge bg-danger animate__animated animate__infinite animate__wobble rounded-3'>
							{$data['unseen']}
						</span>
					";
				};
				
				$data['content'] = "
					<div class='border p-3 my-2 d-flex rounded-2 ticket-cover'>
						<div class='me-3'>
							<img src='{$avatar}' width='30px'>
							<div class='text-center py-1'>{$alert}</div>
						</div>
						<div class='w-100'>
							<div class='position-relative'>
								<div class='mb-2'>	
									<a href='{$href}'>
										<i class='bi bi-ticket fs-16px text-warning'></i> {$data['uniqid']}
									</a>
								</div>
								<h6 class='fw-normal fs-14px fs-sm-16px mb-2'>
									<a href='{$href}'>
										<i class='bi bi-link-45deg me-1'></i> {$data['subject']}
									</a>
								</h6>
								<div class='line-clamp fs-13px text-muted mb-2'>{$summary}</div>
							</div>
							<div class='d-flex flex-wrap justify-content-between'>
								<div class='ticket-frost mb-2'>
									<span class='badge bg-secondary px-2 rounded-3 me-1'>
										<i class='bi bi-chat me-1'></i>{$data['chats']}
									</span>
									<span class='badge bg-{$color} px-2 rounded-3 me-1'>
										{$data['status']}
									</span>
								</div>
								<div class='fs-12px text-end'>
									<i class='bi bi-clock-history me-1 text-muted'></i> {$data['period']}
								</div>
							</div>
						</div>
					</div>
				";
				
				//! Event
				
				events::exec('admin.support-ticket:data', array(
					'data' => &$data,
					'table' => &$table
				));
				
				return $data;
				
			}, true);
		
		?>
		
	</div>
		
<?php });
	
});